/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ConfigurationRepositoryFS
implements ConfigurationRepository {
    private File ssh_home = new File(System.getProperty("user.home"), ".ssh");
    private File jcterm_prop = new File(this.ssh_home, "jcterm.properties");

    @Override
    public Configuration load(String name) {
        Configuration conf = new Configuration();
        conf.name = name;
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.jcterm_prop);
            prop.load(in);
            String key = "jcterm." + name + ".font_size";
            if (prop.get(key) != null) {
                try {
                    conf.font_size = Integer.parseInt((String)prop.get(key));
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            try {
                key = "jcterm." + name + ".fg_bg";
                if (prop.get(key) != null) {
                    conf.fg_bg = ((String)prop.get(key)).split(",");
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            try {
                key = "jcterm." + name + ".destination";
                if (prop.get(key) != null) {
                    conf.destinations = ((String)prop.get(key)).split(",");
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return conf;
    }

    @Override
    public void save(Configuration conf) {
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.jcterm_prop);
            prop.load(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String name = conf.name;
        prop.setProperty("jcterm." + name + ".destination", this.join(conf.destinations));
        prop.setProperty("jcterm." + name + ".font_size", new Integer(conf.font_size).toString());
        prop.setProperty("jcterm." + name + ".fg_bg", this.join(conf.fg_bg));
        try {
            FileOutputStream out = new FileOutputStream(this.jcterm_prop);
            prop.store(out, "");
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    String join(String[] array) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
            if (i + 1 >= array.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }
}

