/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.JCTermAWT;
import com.jcraft.jcterm.JSchSession;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.UserInfo;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;

public class JCTermAWTFrame
extends Frame
implements ActionListener,
Runnable {
    private static final int SHELL = 0;
    private static final int SFTP = 1;
    private static final int EXEC = 2;
    private int mode = 0;
    int port = 22;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = System.getProperty("user.name");
    private String host = "127.0.0.1";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private JSchSession jschsession = null;
    private Proxy proxy = null;
    private int line_space = -2;
    private int compression = 0;
    private Splash splash = null;
    private JCTermAWT term = null;
    private Connection connection = null;
    private Thread thread = null;
    Dialog dialog = null;
    TextField textf = null;
    Button ok = null;
    Label label = null;

    public JCTermAWTFrame(String name) {
        super(name);
        this.enableEvents(8L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MenuBar mb = this.getMenuBar();
        this.setMenuBar(mb);
        this.term = new JCTermAWT();
        this.setSize(this.term.getTermWidth(), this.term.getTermHeight());
        this.add("Center", this.term);
        this.pack();
        this.term.setVisible(true);
        this.setVisible(true);
        this.term.initGraphics();
        this.setResizable(true);
        Insets insets = this.getInsets();
        int foo = this.term.getTermWidth();
        int bar = this.term.getTermHeight();
        this.setSize(foo += insets.left + insets.right, bar += insets.top + insets.bottom);
        this.setResizable(false);
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        block11: {
            if (this.thread != null) {
                try {
                    try {
                        MyUserInfo ui = new MyUserInfo();
                        this.jschsession = JSchSession.getSession(this.user, null, this.host, this.port, ui, this.proxy);
                        Properties config = new Properties();
                        if (this.compression == 0) {
                            config.put("compression.s2c", "none");
                            config.put("compression.c2s", "none");
                        } else {
                            config.put("compression.s2c", "zlib,none");
                            config.put("compression.c2s", "zlib,none");
                        }
                        this.jschsession.getSession().setConfig(config);
                        this.jschsession.getSession().rekey();
                    }
                    catch (Exception e) {
                        break block11;
                    }
                    Channel channel = null;
                    OutputStream out = null;
                    InputStream in = null;
                    if (this.mode == 0) {
                        channel = this.jschsession.getSession().openChannel("shell");
                        if (this.xforwarding) {
                            this.jschsession.getSession().setX11Host(this.xhost);
                            this.jschsession.getSession().setX11Port(this.xport + 6000);
                            channel.setXForwarding(true);
                        }
                        out = channel.getOutputStream();
                        in = channel.getInputStream();
                        channel.connect();
                    } else if (this.mode == 1) {
                        out = new PipedOutputStream();
                        in = new PipedInputStream();
                        channel = this.jschsession.getSession().openChannel("sftp");
                        channel.connect();
                        new Sftp((ChannelSftp)channel, new PipedInputStream((PipedOutputStream)out), new PipedOutputStream((PipedInputStream)in)).kick();
                    }
                    final PipedOutputStream fout = out;
                    final PipedInputStream fin = in;
                    final Channel fchannel = channel;
                    this.connection = new Connection(){

                        @Override
                        public InputStream getInputStream() {
                            return fin;
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return fout;
                        }

                        @Override
                        public void requestResize(Term term) {
                            if (fchannel instanceof ChannelShell) {
                                int c = term.getColumnCount();
                                int r = term.getRowCount();
                                ((ChannelShell)fchannel).setPtySize(c, r, c * term.getCharWidth(), r * term.getCharHeight());
                            }
                        }

                        @Override
                        public void close() {
                            fchannel.disconnect();
                        }
                    };
                    this.setTitle(this.user + "@" + this.host + (this.port != 22 ? new Integer(this.port).toString() : ""));
                    this.term.requestFocus();
                    this.term.start(this.connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setTitle("JCTerm");
        this.thread = null;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void setProxyHttp(String host, int port) {
        this.proxy_http_host = host;
        this.proxy_http_port = port;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String host, int port) {
        this.proxy_socks5_host = host;
        this.proxy_socks5_port = port;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setSplash(Splash foo) {
        this.splash = foo;
    }

    public void setXHost(String xhost) {
        this.xhost = xhost;
    }

    public void setXPort(int xport) {
        this.xport = xport;
    }

    public void setXForwarding(boolean foo) {
        this.xforwarding = foo;
    }

    public void setLineSpace(int foo) {
        this.line_space = foo;
    }

    public void setCompression(int compression) {
        if (compression < 0 || 9 < compression) {
            return;
        }
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setUserHost(String userhost) {
        try {
            String _user = userhost.substring(0, userhost.indexOf(64));
            String _host = userhost.substring(userhost.indexOf(64) + 1);
            this.user = _user;
            this.host = _host;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int port1, String host, int port2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingL(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int port1, String host, int port2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingR(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    private Dialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new Dialog(new Frame(), "", true);
            this.ok = new Button("OK");
            Button cancel = new Button("CANCEL");
            this.textf = new TextField(20);
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            this.ok.addActionListener(this);
            cancel.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(this.ok);
            this.dialog.add(cancel);
            this.dialog.pack();
        }
        this.textf.setEchoCharacter('\u0000');
        return this.dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block47: {
            String action = e.getActionCommand();
            if (action.equals("Open SHELL Session...") || action.equals("Open SFTP Session...")) {
                if (this.thread == null) {
                    if (action.equals("Open SHELL Session...")) {
                        this.mode = 0;
                    } else if (action.equals("Open SFTP Session...")) {
                        this.mode = 1;
                    }
                    while (true) {
                        InputDialog dialog = new InputDialog("Enter username@hostname", "", false);
                        try {
                            String _host = dialog.getText();
                            if (_host == null) {
                                return;
                            }
                            String _user = _host.substring(0, _host.indexOf(64));
                            if ((_host = _host.substring(_host.indexOf(64) + 1)) == null || _host.length() == 0) {
                                return;
                            }
                            this.user = _user;
                            this.host = _host;
                            this.openSession();
                            return;
                        }
                        catch (Exception ee) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (action.equals("HTTP...")) {
                String foo = this.getProxyHttpHost();
                int bar = this.getProxyHttpPort();
                InputDialog dialog = new InputDialog("HTTP proxy server (hostname:port)", foo != null && bar != 0 ? foo + ":" + bar : "", false);
                String proxy = dialog.getText();
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxyHttp(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("SOCKS5...")) {
                String foo = this.getProxySOCKS5Host();
                int bar = this.getProxySOCKS5Port();
                InputDialog dialog = new InputDialog("SOCKS5 server (hostname:1080)", foo != null && bar != 0 ? foo + ":" + bar : "", false);
                String proxy = this.textf.getText();
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxySOCKS5(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("About...")) {
                MessageDialog msg = new MessageDialog("About...", JCTermAWT.COPYRIGHT);
            } else if (action.equals("Compression...")) {
                InputDialog dialog = new InputDialog("Compression level(0-9)", new Integer(this.compression).toString(), false);
                String foo = dialog.getText();
                try {
                    if (foo != null) {
                        this.compression = Integer.parseInt(foo);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("Line Space...")) {
                InputDialog dialog = new InputDialog("Line Space", new Integer(this.line_space).toString(), false);
                String foo = dialog.getText();
                try {
                    if (foo != null) {
                        this.setLineSpace(Integer.parseInt(foo));
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("Local Port...") || action.equals("Remote Port...")) {
                if (this.jschsession == null) {
                    return;
                }
                try {
                    String title = "";
                    title = action.equals("Local Port...") ? title + "Local port forwarding" : title + "remote port forwarding";
                    title = title + "(port:host:hostport)";
                    InputDialog dialog = new InputDialog(title, "", false);
                    String foo = dialog.getText();
                    if (foo == null) {
                        return;
                    }
                    int port1 = Integer.parseInt(foo.substring(0, foo.indexOf(58)));
                    foo = foo.substring(foo.indexOf(58) + 1);
                    String host = foo.substring(0, foo.indexOf(58));
                    int port2 = Integer.parseInt(foo.substring(foo.indexOf(58) + 1));
                    if (action.equals("Local Port...")) {
                        this.setPortForwardingL(port1, host, port2);
                        break block47;
                    }
                    this.setPortForwardingR(port1, host, port2);
                }
                catch (Exception exception) {}
            } else if (action.equals("Quit")) {
                this.quit();
            } else if (action.equals("CANCEL")) {
                this.dialog.setVisible(false);
            }
        }
    }

    @Override
    public MenuBar getMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        MenuItem mi = new MenuItem("Open SHELL Session...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Open SFTP Session...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Quit");
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        m = new Menu("Proxy");
        mi = new MenuItem("HTTP...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("SOCKS5...");
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        m = new Menu("PortForwarding");
        mi = new MenuItem("Local Port...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Remote Port...");
        mi.addActionListener(this);
        m.add(mi);
        m = new Menu("Etc");
        mi = new MenuItem("Compression...");
        mi.addActionListener(this);
        mi.setActionCommand("Compression...");
        m.add(mi);
        mb.add(m);
        m = new Menu("Help");
        mi = new MenuItem("About...");
        mi.addActionListener(this);
        mi.setActionCommand("About...");
        m.add(mi);
        mb.add(m);
        return mb;
    }

    public void quit() {
        this.thread = null;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void setTerm(JCTermAWT term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public static void main(String[] arg) {
        JCTermAWTFrame frame = new JCTermAWTFrame("JCTerm");
        frame.setVisible(true);
        frame.setResizable(true);
    }

    class MessageDialog
    implements ActionListener {
        Dialog dialog = null;

        MessageDialog(String title, String msg) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("OK");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            TextArea text = new TextArea(msg);
            this.dialog.add(text);
            this.dialog.add(ok);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            this.dialog.setVisible(false);
        }
    }

    class PromptDialog
    implements ActionListener {
        boolean result = false;
        Dialog dialog = null;

        PromptDialog(String title, String msg) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("YES");
            Button cancel = new Button("NO");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            cancel.addActionListener(this);
            TextArea text = new TextArea(msg);
            this.dialog.add(text);
            this.dialog.add(ok);
            this.dialog.add(cancel);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals("YES")) {
                this.result = true;
            }
            this.dialog.setVisible(false);
        }
    }

    class InputDialog
    implements ActionListener {
        String result = null;
        Dialog dialog = null;
        TextField textf = null;

        InputDialog(String title, String text, boolean passwd) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("OK");
            Button cancel = new Button("CANCEL");
            this.textf = new TextField(20);
            this.textf.setText(text);
            if (passwd) {
                this.textf.setEchoCharacter('*');
            }
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            cancel.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(ok);
            this.dialog.add(cancel);
            this.dialog.pack();
            this.dialog.setVisible(true);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            } while (this.dialog.isVisible());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals("OK")) {
                this.result = this.textf.getText();
            } else if (action.equals("CANCEL")) {
                // empty if block
            }
            this.dialog.setVisible(false);
        }

        String getText() {
            return this.result;
        }
    }

    public class MyUserInfo
    implements UserInfo {
        String passwd = null;
        String passphrase = null;

        public boolean promptYesNo(String str) {
            PromptDialog dialog = new PromptDialog("Warning", str);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (dialog.isVisible());
            return dialog.result;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String message) {
            InputDialog dialog = new InputDialog(message, "", true);
            this.passwd = dialog.getText();
            return this.passwd != null;
        }

        public boolean promptPassphrase(String message) {
            InputDialog dialog = new InputDialog(message, "", true);
            this.passphrase = dialog.getText();
            return this.passphrase != null;
        }

        public void showMessage(String message) {
            MessageDialog msg = new MessageDialog("", message);
        }
    }
}

